/*
 *  							PS/2 Keyer
 *
 *  Copyright (C) 2009  David Bern, W2LNX     W2LNX@ARRL.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *  USA, or see <http://www.gnu.org/licenses/>.
 */

#include "device.h"
#include "configuration.h"
#include "constants.h"
#include "ps2_protocol_mouse.h"
#include "ps2_mouse.h"
#include <assert.h>

/******************************************************************************/
/*																			  */	
/*					PS/2 mouse specific protocol routines					  */
/*																			  */			
/******************************************************************************/

/* -------------------------------------------------------------------------- */

enum {		/* mouse host command codes */

	MOUSE_RESET					= 0xFF,
	MOUSE_RESEND				= 0xFE,

	SET_RESOLUTION				= 0xE8,
		_8_COUNT_PER_MM			= 0x03,
	SET_SCALING_1_1				= 0xE6,
	SET_SAMPLE_RATE				= 0xF3,
		_200_SAMPLES_PER_SEC	= 0xC8,
		_100_SAMPLES_PER_SEC	= 0x64,
		_80_SAMPLES_PER_SEC		= 0x50,
	GET_DEVICE_ID				= 0xF2,
	ENABLE_DATA_REPORTING		= 0xF4,

	// these are not implemented
	SET_DEFAULTS				= 0xF6,			
	DISABLE_DATA_REPORTING		= 0xF5,
	SET_REMOTE_MODE 			= 0xF0,
	SET_WRAP_MODE 				= 0xEE,
	RESET_WRAP_MODE 			= 0xEC,
	READ_DATA 					= 0xEB,
	SET_STREAM_MODE				= 0xEA,
	STATUS_REQUEST				= 0xE9,
	SET_SCALING_2_1				= 0xE7,
};

enum {		/* mouse device response codes */

	MOUSE_BAT				= 0xAA,
	MOUSE_ACK				= 0xFA,
	MOUSE_ID				= 0x00,
};

/* -------------------------------------------------------------------------- */

static void initialize_device_mouse(void);

static void initialize_host_mouse(void);

/* -------------------------------------------------------------------------- */

/*
 * this routine initializes the mouse device and host ports
 */

void initialize_ps2_mouse(void)
{

#if TESTING == 1
	printf("initialize_ps2_mouse():\r\n");
#endif

	initialize_device_mouse();

	initialize_host_mouse();

#if TESTING == 1
	printf("initialize_ps2_mouse() done\r\n");
#endif
}

/* -------------------------------------------------------------------------- */

/*
 * this routine initialize the PS/2 device mouse port
 *
 *		-- act as a host connected to a mouse device  
 */

static void initialize_device_mouse(void)
{

#if TESTING == 1
	printf("   initialize_device_mouse():\r\n");
#endif

	/* inhibit communications of mouse device */
	output_low(mouse_device_clock);

	// STUB ROUTINE

#if TESTING == 1
	printf("   initialize_device_mouse() done\r\n");
#endif
}

/* -------------------------------------------------------------------------- */

/*
 * this routine initialize the PS/2 host mouse port
 *
 *		-- act as a mouse device connected to host
 */

/*
 * note: this routine only supports plugging in a PS/2 to USB adapter into USB 
 * port after booting Windows XP
 */

static void initialize_host_mouse(void)
{
	unsigned int commandcode;

#if TESTING == 1
	printf("   initialize_host_mouse():\r\n");
#endif

	/* inhibit communications of mouse host */
	output_low(mouse_host_clock);
	delay_ms(100);

	/* send mouse BAT success code and ID */
	send_to_host_mouse(MOUSE_BAT);
	send_to_host_mouse(MOUSE_ID);

	for (;;) {

		/* get a command code from host */
		commandcode = receive_from_host_mouse_wait();
		send_to_host_mouse(MOUSE_ACK);

		if (commandcode == ENABLE_DATA_REPORTING)
			break;

		switch (commandcode) {

		case MOUSE_RESET:
			delay_ms(100);
			send_to_host_mouse(MOUSE_BAT);
			send_to_host_mouse(MOUSE_ID);
			break;

		case SET_RESOLUTION:
		case _8_COUNT_PER_MM:
		case SET_SCALING_1_1:
		case SET_SAMPLE_RATE:
		case _200_SAMPLES_PER_SEC:
		case _100_SAMPLES_PER_SEC:
		case _80_SAMPLES_PER_SEC:
			break;

		case GET_DEVICE_ID:
			send_to_host_mouse(MOUSE_ID);
			break;

		// these code are not implemented
		case SET_DEFAULTS:
		case MOUSE_RESEND:
		case DISABLE_DATA_REPORTING:
		case SET_REMOTE_MODE:
		case SET_WRAP_MODE:
		case RESET_WRAP_MODE:
		case READ_DATA:
		case SET_STREAM_MODE:
		case STATUS_REQUEST:
		case SET_SCALING_2_1:
			printf("commandcode: %02X not implemented\r\n", commandcode);
			break;

		default:
			assert(("unknown command code", FALSE));
			break;
		}

	}

#if TESTING == 1
	printf("   initialize_host_mouse() done\r\n");
#endif
}

/* ------------------------------------------------------------------------- */


